<h3 class="mb-3 fw-bold">Data Transaksi SPP</h3>

<div class="d-flex gap-2 mb-4">
    <button class="btn btn-success fw-bold" data-bs-toggle="modal" data-bs-target="#mSPP">
        <i class="bi bi-plus-lg me-1"></i> Bayar SPP
    </button>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body">
        <!-- Pastikan ID="tabelTransaksi" dan ada class "table-data" -->
<table id="tabelTransaksi" class="table table-bordered table-hover w-100 table-data">
    <thead class="table-light">
        <tr>
            <th>Nama</th>
            <th>Kelas</th>
            <th>Tanggal</th>
            <th>Bulan</th>
            <th>Nominal</th>
            <th class="text-center">Status</th>
            <th class="text-center">Aksi</th>
        </tr>
    </thead>
    <tbody>
        <!-- ... isi PHP loop data ... -->
                <?php
                // Query ambil data
                $q = mysqli_query($koneksi, "SELECT spp.*, siswa.nama, siswa.kelas FROM spp JOIN siswa ON spp.id_siswa = siswa.id ORDER BY spp.id DESC");

                while ($d = mysqli_fetch_array($q)) {
                    // Format Tanggal Indonesia (d-m-Y)
                    // Jika tgl_bayar kosong, pakai tanggal hari ini sebagai default tampilan
                    $tgl = $d['tgl_bayar'] ? date('d-m-Y', strtotime($d['tgl_bayar'])) : date('d-m-Y');
                ?>
                <tr>
                    <td><?= $d['nama']; ?></td>
                    <td><?= $d['kelas']; ?></td>
                    <td><?= $tgl; ?></td> <!-- TAMPILKAN TANGGAL -->
                    <td><?= $d['bulan']; ?></td>
                    <td>Rp <?= number_format($d['jumlah']); ?></td>
                    
                    <td class="text-center">
                        <?php if ($d['status'] == 'Lunas') { ?>
                            <span class="badge bg-success">Lunas</span>
                        <?php } else { ?>
                            <span class="badge bg-danger">Belum</span>
                        <?php } ?>
                    </td>
                    
                    <td class="text-center">
                        <?php if ($d['status'] == 'Belum') { ?>
                            <!-- Tombol Lunasi arahkan ke proses/act_spp.php -->
                            <a href="proses/act_spp.php?aksi=lunasi_spp&id=<?= $d['id']; ?>" 
                               class="btn btn-sm btn-success fw-bold" 
                               onclick="return confirm('Lunasi?')">✅ Lunasi</a>
                        <?php } else { ?>
                            <a href="cetak_spp.php?id=<?= $d['id']; ?>" target="_blank" class="btn btn-sm btn-secondary">
                                <i class="bi bi-printer"></i>
                            </a>
                        <?php } ?>
                        
                        <!-- Link Hapus arahkan ke proses/act_spp.php -->
                        <a href="proses/act_spp.php?aksi=hapus_spp&id=<?= $d['id']; ?>" class="btn btn-sm btn-danger py-0" onclick="return confirm('Hapus?')">X</a>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>

    </div>
</div>

<!-- Modal Bayar SPP -->
<div class="modal fade" id="mSPP">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Action arahkan ke proses/act_spp.php -->
            <form method="POST" action="proses/act_spp.php">
                <div class="modal-header">
                    <h5 class="modal-title">Bayar SPP</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <label class="mb-1">Nama Siswa</label>
                    <select name="id_siswa" class="form-select mb-2" required>
                        <?php
                        $s = mysqli_query($koneksi, "SELECT * FROM siswa ORDER BY nama ASC");
                        while ($r = mysqli_fetch_array($s)) {
                            echo "<option value='$r[id]'>$r[nama] - $r[kelas]</option>";
                        }
                        ?>
                    </select>

                    <label class="mb-1">Untuk Bulan</label>
                    <select name="bulan" class="form-select mb-2">
                        <?php
                        $bln = ['Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember'];
                        foreach ($bln as $b) {
                            echo "<option value='$b " . date('Y') . "'>$b " . date('Y') . "</option>";
                        }
                        ?>
                    </select>

                    <label class="mb-1">Jumlah Bayar</label>
                    <input type="number" name="jumlah" class="form-control mb-2" value="150000" required>

                    <label class="mb-1">Status Pembayaran</label>
                    <select name="status" class="form-select">
                        <option value="Lunas">Lunas</option>
                        <option value="Belum">Belum (Cicil/Pending)</option>
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="submit" name="simpan_spp" class="btn btn-success">Bayar</button>
                </div>
            </form>
        </div>
    </div>
</div>